-- Grammatikken for vores intuitionistiske sprog
module Language where

import Data.Set (Set)
import qualified Data.Set as Set

-- Selve grammatikken
type AtomProp = String

data Formula  = Atom AtomProp
              | Bot
              | And Formula Formula
              | Or  Formula Formula
              | Implies Formula Formula
              deriving (Eq,Ord)
                       
type FormulaSet = Set Formula

-- Pretty printing
-- Sætter parenteser om et udtryk
putpar  :: String -> String
putpar s = "(" ++ s ++ ")" 
-- Definer hvordan show virker på et udsagn
instance Show Formula where
  show (Atom p)     = p
  show (Bot)        = "bot"
  show (And p q)    = putpar $ (show p) ++ " and " ++ (show q)
  show (Or  p q)    = putpar $ (show p) ++ " or " ++ (show q)
  show (Implies p q)= putpar $ (show p) ++ " → " ++ (show q)

-- Streng-repræsentation af værdikonstruktørens navn
getFormulaType  :: Formula -> String
getFormulaType f = 
  case f of
    Atom _      -> "Atom"
    And _ _     -> "Conjunction"
    Or  _ _     -> "Disjunction"
    Implies _ _ -> "Implication"
    Bot         -> "Bot"