-- http://www.haskell.org/haskellwiki/Parsec
module Lexer where

import Text.ParserCombinators.Parsec
import qualified Text.ParserCombinators.Parsec.Token as Tok
import Text.ParserCombinators.Parsec.Language (haskellStyle)

lexer :: Tok.TokenParser ()
lexer = Tok.makeTokenParser haskellStyle
  { Tok.reservedOpNames = ["->","and","or"]
  , Tok.reservedNames = ["bot"]
  }

lexeme :: Parser a -> Parser a
lexeme = Tok.lexeme lexer

parens :: Parser a -> Parser a
parens = Tok.parens lexer

reserved :: String -> Parser ()
reserved = Tok.reserved lexer

reservedOp :: String -> Parser ()
reservedOp = Tok.reservedOp lexer

consume :: Parser a -> Parser a
consume p = do
  Tok.whiteSpace lexer
  r <- p
  eof
  return r