-- https://research.microsoft.com/en-us/um/people/daan/download/parsec/parsec.html
module Parser (parseFormula) where

import Text.ParserCombinators.Parsec
import qualified Text.ParserCombinators.Parsec.Expr as Expr
import Lexer
import Language

atom :: Parser Formula
atom = lexeme $ do
  x <- lower
  xs <- many alphaNum
  let s = (x : xs)
  if s == "bot" then return Bot else return $ Atom s

formula :: Parser Formula
formula = Expr.buildExpressionParser table factor
          where 
           prefixOp x f = Expr.Prefix (reservedOp x >> return f)
           infixOp x f  = Expr.Infix (reservedOp x >> return f)
           table        = [
                           [infixOp "and" And Expr.AssocLeft],
                           [infixOp "or" Or Expr.AssocLeft],
                           [infixOp "->" Implies Expr.AssocLeft]
                          ]
           factor = parens formula
                 <|> atom
                 <?> "proposition / forventede et udsagn"

-- Formelparsing
parseFormula :: String -> Either ParseError Formula
parseFormula = parse (consume formula) "Input udsagnet"